﻿using System.Collections.Generic;
using Microsoft.OData.Edm;
using PpmsDataService.Models;

namespace PpmsDataService.Configuration
{
    using Microsoft.Web.Http;
    using Microsoft.Web.OData.Builder;
    using System.Web.OData.Builder;

    /// <summary>
    /// Represents the model for all Configurations
    /// </summary>
    public class AllConfigurations : IModelConfiguration
    {
        /// <summary>
        /// Applies model configurations using the provided builder for the specified API version.
        /// </summary>
        /// <param name="builder">The <see cref="ODataModelBuilder">builder</see> used to apply configurations.</param>
        /// <param name="apiVersion">The <see cref="ApiVersion">API version</see> associated with the <paramref name="builder"/>.</param>
        public void Apply(ODataModelBuilder builder, ApiVersion apiVersion)
        {
            builder.Function("Geocode").ReturnsFromEntitySet<Coordinates>("Coordinates").Parameter<string>("Address");

            var providerLocator = builder.Function("ProviderLocator");
            providerLocator.Parameter<string>("Address");
            providerLocator.Parameter<int>("Radius");
            providerLocator.Parameter<string>("SpecialtyCode");
            providerLocator.Parameter<int>("Gender");
            providerLocator.Parameter<int>("PrimaryCare");
            providerLocator.Parameter<int>("AcceptingNewPatients");
            providerLocator.Parameter<int>("Network");
            providerLocator.ReturnsFromEntitySet<ProviderLocatorResult>("ProviderLocatorResults");

            var validateAddress = builder.Function("ValidateAddress");
            validateAddress.Parameter<string>("StreetAddress");
            validateAddress.Parameter<string>("City");
            validateAddress.Parameter<string>("State");
            validateAddress.Parameter<string>("Zip");
            validateAddress.ReturnsFromEntitySet<AddressData>("AddressValidationResults");

        }
    }
}